# Filename: functions.R
#
# Project: AISM Paper "On the usage of randomized p-values in the Schweder-Spjotvoll estimator"
# Authors: A. Hoang, T. Dickhaus
#
# Date: 10.12.2020
#
# R Version: 3.6.1
#
# Input data:
# Output data: 


# cdf of null LFC p-value 
FLFC0 <- function(x){
  1-pnorm(qnorm(1-x, 0, 1), sqrt(n)*theta0, 1)
}


# cdf of non-null LFC p-value 
FLFC1 <- function(x){
  1-pnorm(qnorm(1-x, 0, 1), sqrt(n)*theta1, 1)
}

# cdf of null randomized p-value
Frand0 <- function(x,c){
  x*(1-FLFC0(c))+FLFC0(x*c)
}

# cdf of non-null randomized p-value
Frand1 <- function(x,c){
  x*(1-FLFC1(c))+FLFC1(x*c)
}

# the g function; refer to Section 4.3 in the paper
g <- function(x){
  lambda*sum(pLFC>=x)+sum(pLFC<=lambda*x)
}
